/***************************************************************************//**
 *	\file	adc.c
 *
 *	\brief	This file provides all the functionalities provided by ADC driver  
 *			module of Freescale MPC563 power-pc MCU
 *
 *	\version	1.0A - Initial Draft
 *	\date		25 June 2010
 *
 *	\version	1.1A - Design changed to support run-time CCW addition and 
 *						configuration
 *	\date		16 July 2010
 ******************************************************************************/

/******************************************************************************
								Include Files
******************************************************************************/
#include "adc_Cfg.h"
#include "adc.h"


/******************************************************************************
								Type defines
******************************************************************************/
/**	\brief	This structure defines the data for each CCW and the 
			Application call-back function for that conversion */
typedef struct
{
	/** Upper two bits will be used for mask configuration and lower 
		10 bits for CCW Info */
	unsigned short u16CCW_Data;
}QADC_CCW_Data;

/**	\brief	This structure holds all global data of teh ADC module */
 typedef struct
 {
	unsigned short CCW_Data[ADC_MOD_CCW_TOT];
	/** Provides the Queue-2 CCW begin position in the Queue */
	unsigned char u8Q2BeginPos;
 }QADC_Drv;

/******************************************************************************
							Global Variables
******************************************************************************/
/**	\var	self
 *	\brief	This global static variable holds ADC driver related data for each
			ADC converter module */
static QADC_Drv self[ADC_TOT_MOD];

/** \brief	Module A address*/
#define MOD_A_ADDR 0x500
/** \brief	Module B address*/
#define MOD_B_ADDR 0x1000


/**	\brief	This variable holds the address for register array of all the 
			ADC converters */
struct QADC64_tag* const ModRegAddr[ADC_TOT_MOD] = 
									{MOD_A_ADDR, MOD_B_ADDR};

int main()
{
	return 0;
}